;****************************************************************************
; BIOS patch code for
; - AOpen AX6F R2.00 (ax6fw29ee011.bin)
;****************************************************************************
;
; Main file containing new code and data to be added to the BIOS
;
;****************************************************************************
;
; Changes:
; - fix L2 cache handling for Pentium Pro processors
;
;****************************************************************************

;----------------------------------------------------------------------------
; assembler directives/options
;----------------------------------------------------------------------------

[map symbols bin\mainE000.map]
bits 16
cpu 686

;----------------------------------------------------------------------------
; includes
;----------------------------------------------------------------------------

%include	"macro.def"		; macro definitions
%include	"bios.equ"		; addresses of BIOS code and data
					; used in patch routines

;----------------------------------------------------------------------------
; origin
;----------------------------------------------------------------------------

patchStart:
	org 	patchLocE000		; go to free location in E000 segment
					; to place patch data and code into

;----------------------------------------------------------------------------
; data
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
; code
;----------------------------------------------------------------------------

controlL2Cache:
	pushad
	push	ax
	mov	eax, 1
	cpuid
	cmp	al, 30h			; check for a Pentium Pro core
	pop	ax
	jnb	short .klamath
	mov	bl, al			; perform L2 cache control for
	mov	ecx, 119h		; Pentium Pro cores
	rdmsr
	and	eax, 0FFF7FFFFh
	cmp	bl, 0FFh
	jz	short .configure
	or	eax, 80000h
	jmp	short .configure
;----------------------------------------------------------------------------

.klamath:
	mov	bl, al			; perform L2 cache control for
	mov	ecx, 11Eh		; Pentium II (and above)
	rdmsr
	or	eax, 100h
	cmp	bl, 0FFh
	jz	short .configure
	and	eax, 0FFFFFEFFh

.configure:
	wrmsr
	popad
	retn
