@echo off

set BUILD_TARGET=TARGET_AX6F
set BUILD_SYSTEM_ROM=original.tmp
set BUILD_IMAGE=ax6fw29ee011.bin
set BUILD_ARCHIVE_PREFIX=ax6fw29ee011
for /f "usebackq tokens=1,2 delims==" %%i in (`wmic os get LocalDateTime /value 2^>nul`) do if /%%i/==/LocalDateTime/ set BUILD_DATE=%%j
set BUILD_DATE=%BUILD_DATE:~0,8%

set NASM_LOCATION="C:\Program Files (x86)\NASM\nasm.exe"
set WINRAR_LOCATION="C:\Program Files\WinRAR\WinRAR.exe"

pushd "%~dp0"
if errorlevel 1 goto exit

if exist %NASM_LOCATION% (set BUILD_SOURCES=1) else (set BUILD_SOURCES=0)
if exist %WINRAR_LOCATION% (set CREATE_ARCHIVE=1) else (set CREATE_ARCHIVE=0)

echo.
echo ===============================================================================
echo Cleaning up
echo ===============================================================================
echo.
if %BUILD_SOURCES%==1 del bin\* /Q
del work\* /Q
del ..\%BUILD_ARCHIVE_PREFIX%_*.zip

if %BUILD_SOURCES%==1 (
    echo.
    echo ===============================================================================
    echo Building mainE000.asm
    echo ===============================================================================
    echo.
    %NASM_LOCATION% -d%BUILD_TARGET% source\mainE000.asm -isource -obin\mainE000
    if errorlevel 1 goto exit

)

echo.
echo ===============================================================================
echo Decompressing original system ROM
echo ===============================================================================
echo.
tool\lha.exe e original\%BUILD_SYSTEM_ROM% work\
if errorlevel 1 goto exit

echo.
echo ===============================================================================
echo Patching system ROM (first half)
echo ===============================================================================
echo.
tool\ApplyPat.exe patch\mainE000.pat work\%BUILD_SYSTEM_ROM%
if errorlevel 1 goto exit

echo.
echo ===============================================================================
echo Compressing system ROM
echo ===============================================================================
echo.
tool\lha.exe a work\temp.lzh -h1 work\%BUILD_SYSTEM_ROM%
if errorlevel 1 goto exit
del work\%BUILD_SYSTEM_ROM%
ren work\temp.lzh %BUILD_SYSTEM_ROM%

echo.
echo ===============================================================================
echo Fixing system ROM module
echo ===============================================================================
echo.
tool\ApplyPat.exe patch\module_system.pat work\%BUILD_SYSTEM_ROM%
if errorlevel 1 goto exit

echo.
echo ===============================================================================
echo Reassembling and fixing BIOS image
echo ===============================================================================
echo.
copy original\%BUILD_IMAGE% work>nul
if errorlevel 1 goto exit
tool\ApplyPat.exe patch\image.pat work\%BUILD_IMAGE%
if errorlevel 1 goto exit

echo.
echo ===============================================================================
echo Cleaning up
echo ===============================================================================
echo.
copy work\%BUILD_IMAGE% .. /Y>nul
if errorlevel 1 goto exit
del work\* /Q

if %CREATE_ARCHIVE%==1 (
    echo.
    echo ===============================================================================
    echo Building archive
    echo ===============================================================================
    echo.
    %WINRAR_LOCATION% a ..\%BUILD_ARCHIVE_PREFIX%_%BUILD_DATE%.zip ..\%BUILD_IMAGE% ..\build
)

:exit

popd

set BUILD_TARGET=
set BUILD_SYSTEM_ROM=
set BUILD_IMAGE=
set BUILD_ARCHIVE_PREFIX=
set BUILD_DATE=

set NASM_LOCATION=
set WINRAR_LOCATION=

set BUILD_SOURCES=
set CREATE_ARCHIVE=
